package ch.sahits.game.openpatrician.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import ch.sahits.game.openpatrician.model.city.ICity;
/**
 * Implementation of the game map.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 16, 2011
 *
 */
class GameMap implements IMap {
	
	private final LinkedList<ICity> cities = new LinkedList<ICity>();
	/**
	 * Initialize the map by means of a list of its cities.
	 * @param cities
	 */
	public GameMap(ICity...cities){
		for (ICity city : cities) {
			this.cities.add(city);
		}
	}

	@Override
	public int getNumberCities() {
		return cities.size();
	}

	@Override
	public List<ICity> getCities() {
		return Collections.unmodifiableList(cities);
	}

}
