package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.time.IPeriodicalUpdate;

/**
 * Interface for balance data of the a week. The week must not necessairily be completed
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 20, 2012
 *
 */
public interface IBalanceSheet extends IPeriodicalUpdate{
	/**
	 * Retrieve the rental income
	 * @return
	 */
	public int getRentalIncome();
	/**
	 * Retrieve the wage costs
	 * @return
	 */
	public int getWageCosts();
	/**
	 * Retrieve the property taxes
	 * @return
	 */
	public int getPropertyTaxes();
	/**
	 * Retrieve the balance for the office trading
	 * @return
	 */
	public int getOfficeTrading();
	/**
	 * Retrieve the wages for the stewards
	 * @return
	 */
	public int getStewardCost();
	/**
	 * Retrieve other unspecified costs like fines
	 * @return
	 */
	public int getOtherCosts();
	/**
	 * Stop updating the balance sheet with daily updates
	 */
	public void stopUpdate();
	/**
	 * Start updating the balance sheet with daily updates
	 */
	public void startUpdate();
}
