package ch.sahits.game.openpatrician.model;
/**
 * Interface defining a listenable object for clock time updates
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 28, 2011
 *
 */
public interface IClockUpdateListenable {
	/**
	 * Add a new listener that should be updated
	 * @param listener
	 */
	public void add(IClockUpdateListener listener);
	/**
	 * Remove a listener from the queue
	 * @param listener
	 */
	public void remove(IClockUpdateListener listener);
	/**
	 * Notify all registered listeners of a clock tick
	 */
	public void notifyTick();
	/**
	 * Notify all registered listeners of the change in update tick size in minutes
	 */
	public void notifyTickUpdate();
}
