package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.city.ICity;

/**
 * The Company interface represents the company of a player and is mainly used to
 * gather statistics
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 24, 2012
 *
 */
public interface ICompany {
	/**
	 * Retrieve the home town of the company
	 * @return
	 */
	public ICity getHomeTown();
	/**
	 * Retrieve the total value of the company
	 * @return
	 */
	public long getCompanyValue();
	/**
	 * Retrieve the cash avalable to the company
	 * @return
	 */
	public long getCash();
	/**
	 * Add or subtract some cash
	 * @param diff amount of money that is transferred
	 */
	public void updateCash(long diff);
}
