package ch.sahits.game.openpatrician.model;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import ch.sahits.game.openpatrician.model.city.BuildingProduction;
import ch.sahits.game.openpatrician.model.city.CityProduction;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.util.BaseDIFactory;

public class ModelDIFactory extends BaseDIFactory {
	private BeanFactory factory;
	
	private static ModelDIFactory INSTANCE=null;
	/**
	 * Make the constructor portected to ensure it only can be called from super classes
	 * implementing the singleton pattern
	 */
	protected ModelDIFactory(){
		super();
	}
	public static ModelDIFactory getInstance(){
		if (INSTANCE==null){
			INSTANCE=new ModelDIFactory();
		}
		return INSTANCE;
	}

	@Override
	public void init() {
		super.init();
		factory = new ClassPathXmlApplicationContext("springContext.xml");

	}
	/**
	 * Retrieve the PolulationConsumtion instance
	 * @return
	 */
	public PopulationConsume getPolulanceConsumtion(){
		return (PopulationConsume) factory.getBean("citizensConsumtion");
	}
	/**
	 * Retrieve the CityProduction instance
	 * @return
	 */
	public CityProduction getCityProduction(){
		return (CityProduction) factory.getBean("cityProduction");
	}
	/**
	 * Retrieve the BuildingProduction instance
	 * @return
	 */
	public BuildingProduction getBuildingProduction(){
		return (BuildingProduction) factory.getBean("buildingProduction");
	}

}
