package ch.sahits.game.openpatrician.model.building;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;

/**
 * Factory to create building instances. Creating instances also attaches the building to a city
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 17, 2011
 *
 */
public class BuildingFactory {
	/**
	 * Create a new trading office in the city. This method checks if the player has already a traiding
	 * office in the city. If yes an exception is thrown
	 * @param player 
	 * @param city to build the trading office in
	 * @return New instance of a trading office affiliated with the city.
	 * @throws IllegalStateException if the player has already a Trading office in the city
	 */
	public static ITradingOffice createTridingOffice(IPlayer player, ICity city,int value){
		for (IBuilding building : city.getBuildings()) {
			if (building.getOwner()==player && building instanceof ITradingOffice){
				throw new IllegalStateException("The player may only obtain one trading office per city");
			}
		}
		ITradingOffice office = new TradingOffice(player,city,value);
		city.build(office);
		return office;
	}
}
