package ch.sahits.game.openpatrician.model.building;
/**
 * Additional over all ware houses connected to a trading office 
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 25, 2012
 *
 */
public interface IStorage {
	/**
	 * Retrieve the amount of storage in barrels that is rented by someone else
	 * @return
	 */
	public int getRentOutStorage();
	/**
	 * Update the rented out space
	 * @param nbBarrels
	 */
	public void updateRendedSpace(int nbBarrels);
	/**
	 * Retrieve the daily cost for rent storage
	 * @return
	 */
	public int getCostsPerDay();
	/**
	 * Retrieve the number of guards
	 * @return
	 */
	public int getNumberGuards();
	/**
	 * Retrieve the costs for the guards
	 * @return
	 */
	public int getGuardCostsPerDay();
	/**
	 * Retrieve the security level
	 * @return
	 */
	public ELevel getSecurityLevel();
	/**
	 * Increase or decrease the number of guards
	 * @param update
	 */
	public void updateGuardsNumber(int update);

}
