package ch.sahits.game.openpatrician.model.building.impl;

import java.util.Hashtable;

import ch.sahits.game.openpatrician.model.BaseAmountable;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
/**
 * Implementation for the storage of weapons
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 25, 2012
 *
 */
public class WeaponStorage implements IWeaponStorage {
	
	private Hashtable<IWeapon, BaseAmountable<IWeapon>> storage = new Hashtable<IWeapon, BaseAmountable<IWeapon>>();
	
	public WeaponStorage() {
		for (IWeapon weapon : EWeapon.values()){
			BaseAmountable<IWeapon> amountable = new BaseAmountable<IWeapon>();
			storage.put(weapon, amountable);
		}
	}

	@Override
	public int getWeapon(IWeapon weapon) {
		return storage.get(weapon).getAmount();
	}

	@Override
	public int update(IWeapon weapon, int amount) {
		BaseAmountable<IWeapon> amountable = storage.get(weapon);
		int available = amountable.getAmount();
		if (amount<0){
			if (available< -amount){
				amount = -available; // can only move the available amount
			}
			amountable.remove(amount);
		} else {
			amountable.add(amount);
		}
		return amount;
	}
	
	public boolean hasWeapons(){
		for (BaseAmountable<IWeapon> amount : storage.values()) {
			if (amount.getAmount()>0) return true;
		}
		return false;
	}

}
