package ch.sahits.game.openpatrician.model.city;

import java.util.Properties;

import ch.sahits.game.openpatrician.util.PropertyLoader;

/**
 * Enumeration of the home city names
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 13, 2011
 *
 */
public enum ECityName {
	LUEBECK,
	HAMBURG,
	BREMEN,
	KOELN,
	ROSTOCK,
	STETTIN,
	DANZIG,
	VISBY;
	/**
	 * Retrieve the localized city name
	 * @return
	 */
	public String getLocalizedName(){
		Properties props = PropertyLoader.loadProperties("ModelMessages");
		return props.getProperty(this.name());
	}
}
