package ch.sahits.game.openpatrician.model.city;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.util.PropertyLoader;

/**
 * This class defines the amount of wares consumed by each populace class.
 * The amount is per week. The sizes are specified in the ware specific sizes
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 28, 2011
 *
 */
public final class PopulationConsume {
	/** Store the amounts */
	private Map<EWare, Map<EPopulationClass,Double>> needs = new HashMap<EWare, Map<EPopulationClass,Double>>();
	/**
	 * Initialize the needs structure based on a property file
	 * @param propFileName
	 */
	public PopulationConsume(String propFileName) { // different difficulty levels different property files
		Properties props = PropertyLoader.loadProperties(propFileName);
		EWare[] wares = EWare.values();
		EPopulationClass[] classes = EPopulationClass.values();
		for (EWare ware : wares) {
			final String wareName = ware.name();
			Map<EPopulationClass,Double> inner = new HashMap<EPopulationClass, Double>();
			for (EPopulationClass popClass : classes) {
				String key = wareName+"_"+popClass.name();
				double val = Double.parseDouble(props.getProperty(key));
				inner.put(popClass, val);
			}
			needs.put(ware, inner);
		}
	}
	/**
	 * Retrieve the amount needed of a ware by a population class of the size
	 * @param ware to be requested
	 * @param popClass population class
	 * @param popSize number of people of the class
	 * @return amount needed per week
	 */
	public double getNeed(EWare ware,EPopulationClass popClass, int popSize){
		double d = needs.get(ware).get(popClass); // This is the amount for 1000
		d *= popSize/1000.0;
		return d;
	}
	
}
