package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.time.DateObject;
/**
 * Tracking the contibutions of ware over the last seven days rolling.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 24, 2012
 *
 */
public class Contributions {

	private final DailyContribution[] contributions;
	private final Date date;
	private DateObject lastDate;
	
	public Contributions() {
		contributions = new DailyContribution[]{new DailyContribution(),new DailyContribution(),new DailyContribution(),
				                                new DailyContribution(),new DailyContribution(),new DailyContribution(),
				                                new DailyContribution()};
		date = Date.getInstance(0); // TODO ugly
		lastDate = new DateObject(date.getCurrentDate());
	}
	/**
	 * Retrieve the contribution for the whole week
	 * @param ware
	 * @return
	 */
	public int getContribution(IWare ware){
		int sum = 0;
		for (DailyContribution contrib : contributions) {
			sum += contrib.getContribution(ware);
		}
		return sum;
	}
	/**
	 * Contribute the amount of the ware. the amount may be possitive or negative
	 * @param ware
	 * @param amount
	 */
	public void contribute(IWare ware,int amount){
		int index = date.getWeekdayIndex();
		DateObject now = new DateObject(date.getCurrentDate());
		if (!lastDate.isSameDate(now)){
			contributions[index]=new DailyContribution(); // contribution happens on another day
			lastDate=now;
		}
		contributions[index].contribute(ware, amount);
	}
}
