package ch.sahits.game.openpatrician.model.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;


import ch.sahits.game.event.PlayerChangeEvent;
import ch.sahits.game.openpatrician.model.EPlayerStateChange;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.CityFactory;
import ch.sahits.game.openpatrician.model.city.ECityName;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.time.DateObject;
import ch.sahits.game.openpatrician.model.time.EUpdateIntervalRegistration;
import ch.sahits.game.openpatrician.model.time.IPeriodicalUpdate;
import ch.sahits.game.openpatrician.model.time.PeriodicalTimeUpdater;

public final class Company implements ICompany, IPeriodicalUpdate {
	private static final Logger logger = Logger.getLogger(Company.class);
	
	private final IPlayer owner;
	private ICity homeTown;
	private long companyValue;
	private long cash;
	

	public Company(IPlayer owner, ICity homeTown, long cash) {
		super();
		this.owner = owner;
		this.homeTown = homeTown;
		this.cash=cash;
		new PeriodicalTimeUpdater(EUpdateIntervalRegistration.DAY, this);
	}

	@Override
	public ICity getHomeTown() {
		return homeTown;
	}

	@Override
	public long getCompanyValue() {
		return companyValue;
	}

	@Override
	public void notify(DateObject date) {
		companyValue = cash;
		// Add value of all ships
		List<IShip> ships = owner.getFleet();
		for (IShip ship : ships) {
			companyValue += ship.getValue();
			Set<IWare> loaded = ship.getLoadedWares();
			for (IWare ware : loaded) {
				AmountablePrice ap = ship.getWare(ware);
				companyValue+=ap.getAVGPrice()*ap.getAmount();
			}
		}
		
		// Add value of all buildings
		for (ECityName cityName : ECityName.values()) {
			ICity city;
			try {
				city = CityFactory.createCityByName(cityName); // TODO refactor this as bean
				List<IBuilding> buildings = owner.findBuildings(city);
				for (IBuilding building : buildings) {
					companyValue += building.getValue();
					if (building instanceof ITradingOffice){
						ITradingOffice office = (ITradingOffice) building;
						for (IWare ware : EWare.values()) {
							AmountablePrice ap = office.getWare(ware);
							companyValue+=ap.getAVGPrice()*ap.getAmount();
						}
					}
				}
			} catch (IOException e) {
				logger.error("Could not retrieve created cities",e);
			}
			
		}		
	}

	@Override
	public long getCash() {
		return cash;
	}
	/**
	 * Add or subtract some cash
	 * @param diff amount of money that is transferred
	 */
	@Override
	public void updateCash(long diff){
		cash += diff;
		new PlayerChangeEvent().notify(EPlayerStateChange.MONEY);
	}

}
