package ch.sahits.game.openpatrician.model.personal;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.time.DateObject;

/**
 * Defining the personal data of a person.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
public interface IPersonalData {
	/**
	 * Retrieve the players name
	 * @return
	 */
	public String getName();
	/**
	 * Get a players last name
	 * @return
	 */
	public String getLastName();
	/**
	 * Check if the player is male
	 * @return
	 */
	public boolean isMale();
	/**
	 * Retrieve the birth place
	 * @return
	 */
	public ICity getBirthPlace();
	/**
	 * Retrieve the birth date
	 * @return
	 */
	public DateObject getBirthDate();
	
	/**
	 * Compute the current age
	 * @param current date
	 * @return
	 */
	public int getAge(DateObject now);

}
