package ch.sahits.game.openpatrician.model.personal;

import java.awt.image.BufferedImage;
/**
 * Interface defining the personal data of the spouse
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 25, 2012
 *
 */
public interface ISpouseData extends IPersonalData {
	/**
	 * Retrieve an optional portrait
	 * @return
	 */
	public BufferedImage getPortrait();
	/**
	 * Retrieve her popularity in her home town
	 * @return
	 */
	public int getPopularityInHerHomeTown();
	/**
	 * Retrieve her popularity in your home town
	 * @return
	 */
	public int getPopularityInYourHomeTown();
	/**
	 * Retrieve the connectivity to the counsilmen in her home town
	 * @return
	 */
	public int getConnectionsInHerHomeTown();
	/**
	 * Retrieve the connectivity to the counsilmen in your home town
	 * @return
	 */
	public int getConnectionsInYourHomeTown();
	/**
	 * Retrieve the number of children you have with the spouse
	 * @return
	 */
	public int getNumberOfChildren();
	/**
	 * New child is born to you
	 */
	public void newChild();
}
