package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.model.time.DateObject;

public class PersonalData implements IPersonalData {
	
	private final String name;
	private final String lastName;
	private final boolean male;
	private final ICity birthplace;
	private final DateObject birthDate;
	
	/**
	 * Initialize personal data without portrait
	 * @param name
	 * @param lastName
	 * @param male
	 * @param birthplace
	 * @param birthDate
	 */
	public PersonalData(String name, String lastName, boolean male,
			ICity birthplace, DateObject birthDate) {
		super();
		this.name = name;
		this.lastName = lastName;
		this.male = male;
		this.birthplace = birthplace;
		this.birthDate = birthDate;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String getLastName() {
		return lastName;
	}

	@Override
	public boolean isMale() {
		return male;
	}

	@Override
	public ICity getBirthPlace() {
		return birthplace;
	}

	@Override
	public DateObject getBirthDate() {
		return birthDate;
	}

	@Override
	public int getAge(DateObject now) {
		if (birthDate.getMonth()>now.getMonth()){
			// birthday is later in the year
			return now.getYear()-birthDate.getYear()-1;
		} else if (birthDate.getMonth()<now.getMonth()){
			return now.getYear()-birthDate.getYear();
		} else { // same month
			if (birthDate.getDayInMonth()>now.getDayInMonth()){
				// later this month
				return now.getYear()-birthDate.getYear()-1;
			} else {
				return now.getYear()-birthDate.getYear();
			}
		}
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((birthDate == null) ? 0 : birthDate.hashCode());
		result = prime * result
				+ ((birthplace == null) ? 0 : birthplace.hashCode());
		result = prime * result
				+ ((lastName == null) ? 0 : lastName.hashCode());
		result = prime * result + (male ? 1231 : 1237);
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PersonalData other = (PersonalData) obj;
		if (birthDate == null) {
			if (other.birthDate != null)
				return false;
		} else if (!birthDate.equals(other.birthDate))
			return false;
		if (birthplace == null) {
			if (other.birthplace != null)
				return false;
		} else if (!birthplace.equals(other.birthplace))
			return false;
		if (lastName == null) {
			if (other.lastName != null)
				return false;
		} else if (!lastName.equals(other.lastName))
			return false;
		if (male != other.male)
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

}
