package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ReputationCalculator;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.time.DateObject;
import ch.sahits.game.openpatrician.model.time.EUpdateIntervalRegistration;
import ch.sahits.game.openpatrician.model.time.IPeriodicalUpdate;
import ch.sahits.game.openpatrician.model.time.PeriodicalTimeUpdater;
/**
 * Implementation of the reputation.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
public class Reputation implements IReputation, IPeriodicalUpdate {
	
	private int reputationLastWeek = 0;
	private int reputationCurrentWeek = 0;
	
	private final ICity city;
	private final IPlayer player;
	private final ReputationCalculator repCalc = new ReputationCalculator(); // TODO handle this through DI
	

	public Reputation(ICity city, IPlayer player) {
		super();
		this.city = city;
		this.player = player;
		new PeriodicalTimeUpdater(EUpdateIntervalRegistration.WEEK, this);
	}

	@Override
	public int getReputationDifference() {
		return reputationCurrentWeek-reputationLastWeek;
	}
	
	@Override
	public void notify(DateObject date) {
		reputationLastWeek=reputationCurrentWeek;
		reputationCurrentWeek=repCalc.calculateWareRepputation(city, player);
		// TODO add other aspects
	}

	@Override
	public int getPopularity() {
		return reputationCurrentWeek;
	}

}
