package ch.sahits.game.openpatrician.model.personal.impl;

import java.awt.image.BufferedImage;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.time.DateObject;

public class SpouseData extends PersonalData implements ISpouseData {
	
	private final int popHer;
	private final int popYour;
	private final int conHer;
	private final int conYour;
	private final BufferedImage portrait;
	private int nbChildren;
	

	public SpouseData(String name, String lastName, boolean male,
			ICity birthplace, DateObject birthDate, int popHer, int popYour,
			int conHer, int conYour, BufferedImage portrait) {
		super(name, lastName, male, birthplace, birthDate);
		this.popHer = popHer;
		this.popYour = popYour;
		this.conHer = conHer;
		this.conYour = conYour;
		this.portrait = portrait;
		this.nbChildren = 0;
	}

	@Override
	public BufferedImage getPortrait() {
		return portrait;
	}

	@Override
	public int getPopularityInHerHomeTown() {
		return popHer;
	}

	@Override
	public int getPopularityInYourHomeTown() {
		return popYour;
	}

	@Override
	public int getConnectionsInHerHomeTown() {
		return conHer;
	}

	@Override
	public int getConnectionsInYourHomeTown() {
		return conYour;
	}

	@Override
	public int getNumberOfChildren() {
		return nbChildren;
	}
	@Override
	public void newChild(){
		nbChildren++;
	}

}
