package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.BaseAmountable;
import ch.sahits.game.openpatrician.model.IAmountable;
/**
 * This class defines the amounted price of an {@link IWare} object.
 * Each object in the real world has hits unique price. Since no instances of the
 * objects are used but only one reference the price information gets lost. The
 * amountable price tracks the average price of all amounted objects
 * @param <T> {@link IAmountable} implementation that is is collected hereby called item
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 20, 2011
 *
 */
public class AmountablePrice extends BaseAmountable<IWare> {
	/** Total price of all amounted items */
	private long sum = 0;
	/**
	 * Retrieve the average price of one item
	 * @return
	 */
	public int getAVGPrice(){
		return (int)Math.rint(sum*1.0/amount);
	}
	
	
	/**
	 * Add a number items
	 * @param amount number of the items to be added
	 * @param avgPrice average price of one item that is added
	 */
	public void add(int amount, int avgPrice){
		if (amount<0){
			amount = Math.abs(amount);
		}
		this.amount += amount;
		sum += amount*avgPrice;
	}
	/**
	 * Remove a number of items
	 * @param amount of items to be removed
	 */
	public void remove (int amount){
		if (amount<0){
			amount = Math.abs(amount);
		}
		if (amount==Integer.MIN_VALUE){
			amount = Integer.MAX_VALUE;
		}
		if (this.amount<amount){
			this.amount=0;
			sum=0;
		} else {
			sum -=amount*getAVGPrice(); // sum must be updated first
			this.amount -= amount;
		}
		if (this.amount==0){
			sum=0;
		}
	}
	public String toString(){
		return amount+"@"+getAVGPrice();
	}
}
