package ch.sahits.game.openpatrician.model.ship;

import java.util.Set;

import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;

/**
 * Model of a ship
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 15, 2011
 *
 */
public interface IShip {
	// TODO add crew and weapon related stuff
	/**
	 * Total capacity of the ship in barrels
	 * @return
	 */
	public int getSize();
	/**
	 * Available capacity of the ship, this represent the free storage in barrels
	 * @return
	 */
	public int getCapacity();
	/**
	 * Check if the ship can be upgraded
	 * @return
	 */
	public boolean isUpgradable();
	/**
	 * Upgrade the ship if it is upgradable
	 */
	public void upgrade();
	/**
	 * Retrieve the name of the of the ship
	 * @return
	 */
	public String getName();
	/**
	 * Set the ships name
	 * @param name
	 */
	public void setName(String name);
	/**
	 * Retrieve a list of all loaded wares
	 * @return
	 */
	public Set<IWare> getLoadedWares();
	/**
	 * Load the ware in the specified amount onto the ship.
	 * The amount uses the size specified by the ware
	 * @param ware to be loaded
	 * @param amount of items the ware
	 * @return amount actually loaded
	 * @param avgPrice average price of one item of the ware
	 */
	public int load(IWare ware, int amount, int avgPrice);
	/**
	 * Unload the specified quantity of the ware.
	 * The amount uses the size specified by the ware
	 * @param ware to be unloaded
	 * @param amount amount of items of ware to unload
	 * @return amount of the ware unloaded 
	 */
	public int unload(IWare ware, int amount);
	/**
	 * Retrieve the damage of the ship in percentage
	 * @return
	 */
	public int getDamage();
	/**
	 * Damage the ship
	 * @param damage
	 */
	public void damage(Object damage); // TODO create a damage object
	/**
	 * Repair the damage
	 */
	public void repair();
	/**
	 * Retrieve the reduction of the load capacity based on the upgrade level.
	 * The reduction is in barrel that reduces the initial size
	 * @return reduction in barrels
	 */
	public int getUpgradeSpaceReduction();
	/**
	 * Retrieve the amount of load in barrels that is loaded in actual wares (no wappen or crew)
	 * @return amount of loaded wares in barrels
	 */
	public int getLoad();
	/**
	 * Retrieve the amount of ware loaded
	 * @param ware
	 * @return
	 */
	public AmountablePrice getWare(IWare ware);
	/**
	 * check if weapons are on board
	 * @return
	 */
	public boolean hasWeapons();
	/**
	 * Retrieve the current value of the ship without its cargo
	 * @return
	 */
	public int getValue();
}
