package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.ship.impl.Cog;
import ch.sahits.game.openpatrician.model.ship.impl.Crayer;
import ch.sahits.game.openpatrician.model.ship.impl.Holk;
import ch.sahits.game.openpatrician.model.ship.impl.Snaikka;

/**
 * This factory class creates ship instances.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 19, 2011
 *
 */
public class ShipFactory {
	/**
	 * Create a a crayer with the given name. The crayer is not upgraded
	 * @param name
	 * @return
	 */
	public static ICrayer createCrayer(String name,int value){
		return new Crayer(name,value);
	}
	/**
	 * Create a crayer with the given name. The crayer is upgraded to the specified level
	 * @param name
	 * @param upgradeLevel
	 * @return
	 */
	public static ICrayer createCrayer(String name, EShipUpgrade upgradeLevel,int value){
		return new Crayer(upgradeLevel, name,value);
	}
	/**
	 * Create a a snaikka with the given name. The snaikka is not upgraded
	 * @param name
	 * @return
	 */
	public static ISnaikka createSnaikka(String name,int value){
		return new Snaikka(name,value);
	}
	/**
	 * Create a snaikka with the given name. The snaikka is upgraded to the specified level
	 * @param name
	 * @param upgradeLevel
	 * @return
	 */
	public static ISnaikka createSnaikka(String name, EShipUpgrade upgradeLevel,int value){
		return new Snaikka(upgradeLevel, name,value);
	}
	/**
	 * Create a a cog with the given name. The cog is not upgraded
	 * @param name
	 * @return
	 */
	public static ICog createCog(String name,int value){
		return new Cog(name,value);
	}
	/**
	 * Create a cog with the given name. The cog is upgraded to the specified level
	 * @param name
	 * @param upgradeLevel
	 * @return
	 */
	public static ICog createCog(String name, EShipUpgrade upgradeLevel,int value){
		return new Cog(upgradeLevel, name,value);
	}
	/**
	 * Create a a holk with the given name. The holk is not upgraded
	 * @param name
	 * @return
	 */
	public static IHolk createHolk(String name,int value){
		return new Holk(name,value);
	}
	/**
	 * Create a holk with the given name. The holk is upgraded to the specified level
	 * @param name
	 * @param upgradeLevel
	 * @return
	 */
	public static IHolk createHolk(String name, EShipUpgrade upgradeLevel,int value){
		return new Holk(upgradeLevel, name,value);
	}

}
