package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.ICrayer;


/**
 * This model represents a crayer.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 19, 2011
 *
 */
public class Crayer extends Ship implements ICrayer {
	/** Size in barrels */
	private int size = 350; // this is not final since the size changes by year and shipyard
	/**
	 * Constructor initializing the name and the upgrade level
	 * @param upgradeLevel
	 * @param name
	 */
	public Crayer(EShipUpgrade upgradeLevel, String name,int value) {
		super(value);
		this.upgradeLevel = upgradeLevel;
		this.name = name;
	}
	/**
	 * Constructor for a Crayer without any upgrade
	 * @param name
	 */
	public Crayer(String name, int value) {
		this(EShipUpgrade.NONE,name,value);
	}
	@Override
	public int getCapacity() {
		return size-getUpgradeSpaceReduction()-getLoad();
	}

	@Override
	public int getUpgradeSpaceReduction(){
		switch (upgradeLevel) {
		case NONE:
			return 0;
		case LEVEL1:
			return 90;
		case LEVEL2:
			return 190;
		default:
			return 0;
		}
	}
	

	@Override
	public int getSize() {
		return size;
	}

	@Override
	public int getDamage() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void damage(Object damage) {
		// TODO Auto-generated method stub

	}

	@Override
	public void repair() {
		// TODO Auto-generated method stub

	}

}
