package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IHolk;

public class Holk extends Ship implements IHolk {
	/** Size in barrels */
	private int size = 700; // this is not final since the size changes by year and shipyard
	/**
	 * Constructor initializing the name and the upgrade level
	 * @param upgradeLevel
	 * @param name
	 */
	public Holk(EShipUpgrade upgradeLevel, String name,int value) {
		super(value);
		this.upgradeLevel = upgradeLevel;
		this.name = name;
	}
	/**
	 * Constructor for a Crayer without any upgrade
	 * @param name
	 */
	public Holk(String name, int value) {
		this(EShipUpgrade.NONE,name,value);
	}
	@Override
	public int getSize() {
		return size;
	}
	@Override
	public int getDamage() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public void damage(Object damage) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void repair() {
		// TODO Auto-generated method stub
		
	}
	@Override
	public int getCapacity() {
		return size-getUpgradeSpaceReduction()-getLoad();
	}

	@Override
	public int getUpgradeSpaceReduction(){
		switch (upgradeLevel) {
		case NONE:
			return 0;
		case LEVEL1:
			return 200;
		case LEVEL2:
			return 350;
		default:
			return 0;
		}
	}

}
