package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.model.ship.EShipSide;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;

/**
 * This class defines a weapon and its location on board a ship.
 * There are weapons that take up two slots.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 23, 2011
 *
 */
final class WeaponsLocation {
	/** Side of the ship either port or starboard */
	private final EShipSide side;
	/** The weapon in the slot */
	private final EWeapon weapon;
	/** 
	 * Slot that is occupied by the weapon. If the weapon occupies two slots
	 * it is the slot closest to the stern.
	 */
	private final int slot;
	public WeaponsLocation(EShipSide side, EWeapon weapon, int slot) {
		super();
		this.side = side;
		this.weapon = weapon;
		this.slot = slot;
	}
	public EShipSide getSide() {
		return side;
	}
	public EWeapon getWeapon() {
		return weapon;
	}
	public int getSlot() {
		return slot;
	}
	
}
