package ch.sahits.game.openpatrician.model.time;

import java.util.Calendar;

import ch.sahits.game.openpatrician.model.Date;

/**
 * This simple date object holds a date with year, month, day of month, day in week (starting with monday),
 * hour and minute.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 22, 2012
 *
 */
public final class DateObject {
	private final int year;
	private final int month;
	private final int dayInMonth;
	private final int dayInWeek;
	private final int hour;
	private final int minute;
	public DateObject(final Calendar cal) {
		super();
		this.year = cal.get(Calendar.YEAR);
		this.month = cal.get(Calendar.MONTH);
		this.dayInMonth = cal.get(Calendar.DAY_OF_MONTH);
		this.dayInWeek = (cal.get(Calendar.DAY_OF_WEEK)-Calendar.MONDAY)%7;
		this.hour = cal.get(Calendar.HOUR_OF_DAY);
		this.minute = cal.get(Calendar.MINUTE);
	}
	public int getYear() {
		return year;
	}
	public int getMonth() {
		return month;
	}
	public int getDayInMonth() {
		return dayInMonth;
	}
	/**
	 * Retrieve the day in the week starting with Monday at index 0
	 * @return
	 */
	public int getDayInWeek() {
		return dayInWeek;
	}
	public int getHour() {
		return hour;
	}
	public int getMinute() {
		return minute;
	}
	/**
	 * Representation that can be displayed
	 * @return
	 */
	public String toDisplayString(){
		Date date = Date.getInstance(0); // TODO ugly
		return date.todisplayString(dayInMonth, month, year);
	}
	
	public boolean isSameDate(DateObject date){
		if (getDayInMonth()!=date.getDayInMonth() ||
			getMonth()!=date.getMonth() ||
			getYear()!=date.getYear()){
			return false;
		} else {
			return true;
		}

	}
	
}
