package ch.sahits.game.openpatrician.model.weapon;

import java.util.ResourceBundle;

import ch.sahits.game.openpatrician.util.l10n.Locale;

/**
 * Enumeration defining all weapons
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 23, 2011
 *
 */
public enum EWeapon implements IWeapon {
	SWORD,
	BOW,
	CROSSBOW,
	MUSKET,
	BALLISTA_SMALL,
	TREBUCHET_SMALL,
	BALLISTA_BIG,
	TREBUCHET_BIG,
	BOMBARD,
	CANNON,
	HAND_WEAPON;
	private final Locale locale = Locale.getInstance();
	/**
	 * Retrieve the localized display name for <code>id</code>.
	 * @param id
	 * @return
	 */
	@Override
	public String getLocalDisplayName(){
		ResourceBundle messages = ResourceBundle.getBundle("weapons", locale.getCurrentLocal());
		return messages.getString(this.name());
	}

}
