package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.ship.IShip;

import java.util.List;

/**
 * Player in the game.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 15, 2011
 *
 */
public interface IPlayer extends ICitizen {
	/**
	 * Retrieve the personal data of the player
	 * @return
	 */
	public IPersonalData getPersonalData();
	/**
	 * Retrieve the personal data of the players spouse.
	 * @return
	 */
	public ISpouseData getSpouseData();
	/**
	 * Retrieve the company data
	 * @return
	 */
	public ICompany getCompany();

	/**
	 * Get a list of all ships
	 * @return
	 */
	public List<IShip> getFleet();
	/**
	 * Find all ships in a city
	 * @param city
	 * @return
	 */
	List<IShip> findShips(ICity city);
	/**
	 * Add a new ship for the player
	 * @param ship
	 */
	public void addShip(IShip ship);
	/**
	 * Remove a ship for the player
	 * @param ship
	 */
	public void removeShip(IShip ship);
	/**
	 * Check if the player is male
	 * @return
	 */
	public boolean isMale(); // TODO remove
	/**
	 * Retrieve the amount of money of the player
	 * @return
	 */
	public long getCash(); // TODO remove

	/**
	 * Change the available cash of the player
	 * @param diff
	 */
	public void updateCash(int diff); // TODO remove
	/**
	 * Find all buildings of the player in the city
	 * @param city
	 * @return
	 */
	public List<IBuilding> findBuildings(ICity city);
	/**
	 * Find the trading office of the player in the city.
	 * If there is no trading office null will be returned.
	 * @param city
	 * @return
	 */
    // todo: andi 10/04/14: wrap the return value into an optional
	public ITradingOffice findTradingOffice(ICity city);
	/**
	 * Find all buildings in the city that are some subtype of the indicated class
	 * @param city
	 * @param buildingClass
	 * @return
	 */
	public List<IBuilding> findBuildings(ICity city, Class<? extends IBuilding> buildingClass);

	/**
	 * Update to the new social rank
	 * @param rank
	 */
	public void updateRank(ESocialRank rank);
	/**
	 * Retrieve the career level, which is either defined by {@link EMilitantCareer} or {@link EEconomicCareer}.
	 * @return
	 */
	public ICareer getCareerLevel();

	/**
	 * Set or unset the image for a segmented map (treasure or pirate hideout).
	 * @param mapSegments
	 */
	void setSegmentedMap(MapSegmentedImage mapSegments);

	/**
	 * Retrieve the segmented image map.
	 * @return
	 */
	MapSegmentedImage getSegmentedMap();
}
