package ch.sahits.game.openpatrician.model.building;
/**
 * This interface represents a workshop, which employs workers
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 22, 2012
 *
 */
public interface IWorkShop extends IBuilding {
	/**
	 * Retrieve the number of workers in the shop
	 * @return
	 */
	public int getWorkers();
	/**
	 * Retrieve the number of workers maximal employable by this shop
	 * @return
	 */
	public int getMaxWorkers();
	/**
	 * Retrieve the salary a worker earns within a week
	 * @return
	 */
	public int getSalaryPerWorker();
}
