package ch.sahits.game.openpatrician.model.city;

import org.joda.time.DateTime;

import ch.sahits.game.openpatrician.model.ship.IShip;


/**
 * Simple abstraction of a due date for a ship. This can be used
 * for ship building or repairs.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Mar 9, 2013
 *
 */
public interface IShipDueDate {
	/**
	 * Retrieve the ship that is due.
	 * @return ship
	 */
	IShip getShip();
	/**
	 * Retrieve the due date of the ship.
	 * @return date time.
	 */
	DateTime getDueDate();
}
