package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.base.Optional;
import org.joda.time.DateTime;

import java.util.List;

/**
 * Representing the state of the various issues that may be addressed
 * at the city hall.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ICityHall {
    /**
     * Retrieve the list of notices for wares that can be delivered
     * to other cities at a guaranteed price. These notices get updated
     * on a weekly basis.
     * @return
     */
    List<ICityHallNotice> getNotices();

    /**
     * Current outrigger of the city. As the city may not have an outrigger
     * assigned it may be absent.
     * @return
     */
    Optional<IShip> getOutrigger();

    /**
     * Current mayor of the city
     * @return
     */
    ICitizen getMayor();

    /**
     * Date of the next election. Elections happen all 2 years.
     * @return
     */
    DateTime getElectionDate();

    /**
     * Retrieve the list of candidates for the next election.
     * @return
     */
    List<ICitizen> getCandidates();

    /**
     * Date of the next council meeting to discuss a petition.
     * @return
     */
    Optional<DateTime> getNextCouncilMeeting();

    /**
     * Petition to be discussed at the next council meeting.
     * @return
     */
    Optional<ICityPetition> getPetition();

    /**
     * Retrieve the elderman.
     * @return
     */
    ICitizen getElderman();

    /**
     * Date of the next elderman election.
     * @return
     */
    DateTime getEldermanElectionDate();

    /**
     * Retrieve the top four of the candidates for the elderman post.
     * @return
     */
    List<ICitizen> getEldermanCandidates();

    /**
     * Retrieve the treasury.
     * @return
     */
    ITreasury getTreasury();

    /**
     * Retrieve the city guard.
     * @return
     */
    List<ICityGuard> getCityGuard();

    /**
     * Retrieve the office of the elderman. This office is
     * only available if the elderman resides in the currenct city.
     * @return
     */
    Optional<IEldermanOffice> getEldermanOffice();

    /**
     * Method handling daily updates.
     */
    void updateDaily();

    /**
     * Method handling weekly updates.
     */
    void updateWeekly();

    /**
     * Method handling monthly updates.
     */
    void updateMonthly();

    /**
     * Method to handel the end of year updates.
     */
    void updateEndOfYear();

}
