package ch.sahits.game.openpatrician.model.city.cityhall;

import com.google.common.base.Optional;

import java.util.List;

/**
 * Office of the elderman. The elderman can order hanseatic days or
 * a player can take a task to fulfill should he have sufficient reputation.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface IEldermanOffice {
    /**
     * Retrieve the list of available tasks.
     * @return
     */
    List<IEldermanTask> getTasks();

    /**
     * Get the current violation. As there might be non this might be absent.
     * @return
     */
    Optional<ICityViolation> getViolation();

    /**
     * Monthly check if there should be new tasks or violations added.
     */
    void update();
}
