package ch.sahits.game.openpatrician.model.city.cityhall;

/**
 * Treasury of the city.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ITreasury {
    /**
     * Retrieve the current height of the taxes.
     * @return
     */
    double getCurrentHeadTaxValue();

    /**
     * Retrieve the current property tax.
     * @return
     */
    double getCurrentPropertyTax();

    /**
     * Amount of the property and head taxes up to date this year.
     * @return
     */
    long getPaidTaxes();

    /**
     * Amount of the paid special taxes.
     * @return
     */
    long getPaidSpecialTaxes();

    /**
     * Monthly costs of the city guard.
     * @return
     */
    int getCityGuardCosts();

    /**
     * Costs for the building of city walls and towers up to date.
     * This value is only positive if there is a building being built.
     * @return
     */
    int getBuildingCosts();

    /**
     * Costs for paying the outrigger.
     * @return
     */
    int getOutriggerCosts();

    /**
     * Paid ransom to prevent/abort siege.
     * @return
     */
    int getSiegeCosts();

    /**
     * Costs and fees that the city has to have payed up to this date in the current year.
     * Included here are also stolen amounts.
     * @return
     */
    int getOtherCosts();

    /**
     * All other income like donations.
     * @return
     */
    int getOtherIncome();

    /**
     * Update the total amount of cash in the treasury. This can be stolen or donated.
     * @param cash
     */
    void update(long cash);

}
