package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.product.IWare;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Tracking the contibutions of ware over the last seven days rolling.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 24, 2012
 *
 */
@Prototype
public class Contributions {

	private final DailyContribution[] contributions;
	@Autowired
	private Date date;
	private DateTime lastDate;
	private DateTimeComparator comperator;

	public Contributions() {
		contributions = new DailyContribution[]{new DailyContribution(),new DailyContribution(),new DailyContribution(),
				new DailyContribution(),new DailyContribution(),new DailyContribution(),
				new DailyContribution()};
		comperator = DateTimeComparator.getDateOnlyInstance();
	}
	@PostConstruct
	private void init() {
		lastDate = date.getCurrentDate();
	}
	/**
	 * Retrieve the contribution for the whole week
	 * @param ware
	 * @return
	 */
	public int getContribution(IWare ware){
		int sum = 0;
		for (DailyContribution contrib : contributions) {
			sum += contrib.getContribution(ware);
		}
		return sum;
	}
	/**
	 * Contribute the amount of the ware. the amount may be possitive or negative
	 * @param ware
	 * @param amount
	 */
	public void contribute(IWare ware,int amount){
		int index = date.getWeekdayIndex();
		DateTime now = date.getCurrentDate();
		if (comperator.compare(lastDate, now) != 0){
			contributions[index]=new DailyContribution(); // contribution happens on another day
			lastDate=now;
		}
		contributions[index].contribute(ware, amount);
	}
}
