package ch.sahits.game.openpatrician.model.city.impl;

import java.util.HashMap;
import java.util.Map;

import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;

public class DailyContribution {

	private final Map<IWare, Integer> contributions;
	public DailyContribution() {
		contributions = new HashMap<IWare, Integer>();
		for (EWare ware : EWare.values()) {
			contributions.put(ware, 0);
		}
	}
	/**
	 * Retrieve the contributions for the day
	 * @param ware
	 * @return
	 */
	public int getContribution(IWare ware){
		if (contributions.containsKey(ware)){
			return contributions.get(ware);
		} else {
			return 0; // Test case where IWare is mocked
		}
	}
	/**
	 * Update the contribution for the day the amount may be positive or negative
	 * @param ware
	 * @param amount
	 */
	public void contribute(IWare ware,int amount){
		if (!contributions.containsKey(ware)){
			contributions.put(ware, 0); // Test case where IWare is mocked
		}
		int contributed = contributions.get(ware);
		contributed += amount;
		contributions.put(ware, contributed);
	}
}
