package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ILoanRequest;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Builder;
import org.joda.time.DateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
@RequiredArgsConstructor
@Builder
public class LoanRequest implements ILoanRequest {
    private final DateTime issued;
    @Getter
    private final ICitizen citizen;
    @Getter
    private final int durationInWeeks;
    @Getter
    private final int sum;

    @Override
    public DateTime issued() {
        return issued;
    }
}
