package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.ICity;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * Event object for a finished building.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 23, 2014
 */
@EqualsAndHashCode
@RequiredArgsConstructor
public class BuildingFinished {
    @NonNull
    @Getter
    private final IBuilding building;
    @NonNull
    @Getter
    private final IPlayer owner;
    @NonNull
    @Getter
    private final ICity city;
}
