package ch.sahits.game.openpatrician.model.factory;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.Contributions;
import ch.sahits.game.openpatrician.model.impl.BalanceSheet;
import ch.sahits.game.openpatrician.model.personal.impl.Reputation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

/**
 * Factory for constructing beans around players actions.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 30, 2014
 */
@Service
public class PlayerInteractionFactory {
    @Autowired
    private ApplicationContext context;
    public Contributions createContribution() {
        return context.getBean(Contributions.class);
    }
    public Reputation createReputation(ICity city, IPlayer player) {
        return (Reputation) context.getBean("reputation", new Object[]{city, player});
    }

    /**
     * Create an initial balance sheet for player in city.
     * @param city .
     * @param player .
     * @return blank Balance sheet
     */
    public BalanceSheet createInitialBalanceSheet(ICity city, IPlayer player) {
        final BalanceSheet balanceSheet = (BalanceSheet) context.getBean("balanceSheet", new Object[]{city, player});
        return balanceSheet;
    }

    /**
     * Create a balance sheet based upon the balance of the previous week.
     * @param previousWeek last weeks balance sheet.
     * @return updated balance sheet.
     */
    public BalanceSheet createBalanceSheetFromPreviousWeek(BalanceSheet previousWeek) {
        final BalanceSheet balanceSheet = (BalanceSheet) context.getBean("balanceSheet", new Object[]{previousWeek});
        return balanceSheet;
    }

}
