package ch.sahits.game.openpatrician.model.factory;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

/**
 * Factory to create all the dependent state model objects.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 30, 2014
 */
@Service
public class StateFactory {
    @Autowired
    private ApplicationContext context;

    public IShipyard createShipYard(ICity city) {
        return (IShipyard) context.getBean("shipyardState", new Object[]{city});
    }
    public TavernState createTavernState(ICity city) {
        return (TavernState) context.getBean("tavernState", new Object[]{city});
    }

    public ILoaner createLoaner(ICity city) {
        return (ILoaner) context.getBean("loanerState", new Object[]{city});
    }
}
