package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.event.data.PeriodicalTimeDayUpdate;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITownHouse;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.factory.PeriodicalTimeUpdateFactory;
import ch.sahits.game.openpatrician.model.time.EUpdateIntervalRegistration;
import ch.sahits.game.openpatrician.model.time.PeriodicalTimeUpdaterV2;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import java.util.List;
/**
 * 
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 9, 2013
 *
 */
@Prototype
public class BalanceSheet implements IBalanceSheet {

	//	private final Calendar start;
	private final ICity city;
	private final IPlayer player;
	@Autowired
	private Date gameDate;
	@Autowired
	private PeriodicalTimeUpdateFactory updateFactory;
	private PeriodicalTimeUpdaterV2 updater;

    @Getter
	private int rentalIncome;
	private int[] rentalIncomeDays;
    @Getter
	private int wageCosts;
	private int[] wageCostsDays;
    @Getter
	private int propertyTaxes;
	private int[] propertyTaxesDays;
    @Getter
	private int officeTrading;
	private int[] officeTradingDays;
    @Getter
	private int stewardCost;
	private int[] stewardCostsDays;
    @Getter
	private int otherCosts;
	private int[] otherCostsDays;
	@Autowired
	@Qualifier("serverClientEventBus")
	private AsyncEventBus clientServerEventBus;


	/**
	 * Initialize a blank sheet
	 */
	public BalanceSheet(ICity city, IPlayer player) {
		super();
		this.city = city;
		this.player = player;

		rentalIncome = 0;
		rentalIncomeDays = new int[]{0,0,0,0,0,0,0};
		wageCosts = 0;
		wageCostsDays = new int[]{0,0,0,0,0,0,0};
		propertyTaxes = 0;
		propertyTaxesDays = new int[]{0,0,0,0,0,0,0};
		officeTrading = 0;
		officeTradingDays = new int[]{0,0,0,0,0,0,0};
		stewardCost = 0;
		stewardCostsDays = new int[]{0,0,0,0,0,0,0};
		otherCosts = 0;
		otherCostsDays = new int[]{0,0,0,0,0,0,0};
	}
	/**
	 * Initialize a forcast balance sheet by using the balance sheet of the previous week
	 * @param prevWeek
	 */
	public BalanceSheet(BalanceSheet prevWeek){
		city = prevWeek.city;
		player = prevWeek.player;
		prevWeek.clientServerEventBus.unregister(prevWeek);
		rentalIncome = prevWeek.rentalIncomeDays[6]*7;
		rentalIncomeDays = new int[]{prevWeek.rentalIncomeDays[6],prevWeek.rentalIncomeDays[6],prevWeek.rentalIncomeDays[6],prevWeek.rentalIncomeDays[6],prevWeek.rentalIncomeDays[6],prevWeek.rentalIncomeDays[6],prevWeek.rentalIncomeDays[6]};
		wageCosts = prevWeek.wageCostsDays[6]*7;
		wageCostsDays = new int[]{ prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6], prevWeek.wageCostsDays[6]};
		propertyTaxes = prevWeek.propertyTaxesDays[6]*7;
		propertyTaxesDays = new int[]{prevWeek.propertyTaxesDays[6],prevWeek.propertyTaxesDays[6],prevWeek.propertyTaxesDays[6],prevWeek.propertyTaxesDays[6],prevWeek.propertyTaxesDays[6],prevWeek.propertyTaxesDays[6],prevWeek.propertyTaxesDays[6]};
		officeTrading = prevWeek.officeTradingDays[6]*7;
		officeTradingDays = new int[]{prevWeek.officeTradingDays[6],prevWeek.officeTradingDays[6],prevWeek.officeTradingDays[6],prevWeek.officeTradingDays[6],prevWeek.officeTradingDays[6],prevWeek.officeTradingDays[6],prevWeek.officeTradingDays[6]};
		stewardCost = prevWeek.stewardCostsDays[6]*7;
		stewardCostsDays = new int[]{prevWeek.stewardCostsDays[6],prevWeek.stewardCostsDays[6],prevWeek.stewardCostsDays[6],prevWeek.stewardCostsDays[6],prevWeek.stewardCostsDays[6],prevWeek.stewardCostsDays[6],prevWeek.stewardCostsDays[6]};
		otherCosts = prevWeek.otherCosts;
		otherCostsDays = new int[]{prevWeek.otherCosts/7,prevWeek.otherCosts/7,prevWeek.otherCosts/7,prevWeek.otherCosts/7,prevWeek.otherCosts/7,prevWeek.otherCosts/7,prevWeek.otherCosts/7};
	}
	@PostConstruct
	private void init() {
		updater = updateFactory.createPeriodicalUpdater(EUpdateIntervalRegistration.END_OF_DAY);
		clientServerEventBus.register(this);
	}
	@Subscribe
	public void handleDailyUpdate(PeriodicalTimeDayUpdate event){
		// TODO aho Dec 6, 2013: initialisation only happens on the second day.
		ITradingOffice office = player.findTradingOffice(city);
		int weekIndex = gameDate.getCurrentDate().getDayOfWeek(); // TODO this might return -1
		ISteward steward = office.getSteward();
		int dailyCost=0;
		if (steward!=null){
			dailyCost = (int) Math.rint(steward.getSalary()/7.0);
		}
		for (int i = weekIndex; i<stewardCostsDays.length;i++){
			stewardCostsDays[i] = dailyCost;
		}
		int sum = 0;
		for (int cost : stewardCostsDays) {
			sum += cost;
		}
		stewardCost=sum;

		List<IBuilding> buildings = player.findBuildings(city,ITownHouse.class);
		dailyCost=0;
		for (IBuilding building : buildings) {
			dailyCost += ((ITownHouse)building).computeRentalIncome();
		}
		for (int i = weekIndex; i<rentalIncomeDays.length;i++){
			rentalIncomeDays[i] = dailyCost;
		}
		sum = 0;
		for (int cost : rentalIncomeDays) {
			sum += cost;
		}
		rentalIncome=sum;

		buildings = player.findBuildings(city);
		dailyCost=0;
		for (IBuilding building : buildings) {
			dailyCost += building.getPropertyTax();
		}
		for (int i = weekIndex; i<propertyTaxesDays.length;i++){
			propertyTaxesDays[i] = dailyCost;
		}
		sum = 0;
		for (int cost : propertyTaxesDays) {
			sum += cost;
		}
		propertyTaxes=sum;

		buildings = player.findBuildings(city,IWorkShop.class);
		IStorage storage = office.getStorage();
		dailyCost=0;
		for (IBuilding building : buildings) {
			dailyCost += (int)Math.rint(((IWorkShop)building).getSalaryPerWorker()/7.0);
		}
		for (int i = weekIndex; i<wageCostsDays.length;i++){
			wageCostsDays[i] = dailyCost+storage.guardCostsPerDayBinding().get();
		}
		sum = 0;
		for (int cost : wageCostsDays) {
			sum += cost;
		}
		wageCosts=sum;

		IAutomatedTrading automaticTrading = office.getOfficeTrading();
		if (automaticTrading!=null){
			// TODO implement this when implementing office trading
		} else {
			for (int i = weekIndex; i<officeTradingDays.length;i++){
				officeTradingDays[i] = 0;
			}
		}
		sum = 0;
		for (int cost : officeTradingDays) {
			sum += cost;
		}
		officeTrading=sum;

		// TODO update other expences
		for (int i = weekIndex; i<otherCostsDays.length;i++){
			otherCostsDays[i] = storage.costsPerDayBinding().get();
		}
		// todo: andi 11/16/14: add to cost for additional storing space
	}


}
