package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * A citizen is an inhabitatant of a town, who does not directly partake in
 * the game play. There may be interactions with citizens (e.g. loans).
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
@RequiredArgsConstructor
public class Citizen implements ICitizen {
    @Getter
    private final String lastName;
    @Getter
    private final String name;
    @Getter
    private final ESocialRank rank;
    @Getter
    private final ICity hometown;
}
