package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.IPlayer;


/**
 * Another player asking to harm his concurrent by sinking
 * one of his ships.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface IConcurrent extends ISideRoomPerson {
	/**
	 * Name of the client
	 * @return
	 */
	String getName();
	/**
	 * Name of the concurrent who is to be harmed.
	 * @return
	 */
	String getConcurrentName();
	/**
	 * Get the player that is the client
	 * @return
	 */
	IPlayer getClientPlayer();
	/**
	 * Retrieve the concurrent player
	 * @return
	 */
	IPlayer getConcurrentPlayer();
	/**
	 * Promissed premium.
	 * @return
	 */
	int getPremium();

}
