package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IContractBroker;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import lombok.Getter;

/**
 * Implementation of a contract brooker. Every city can have a contract brooker and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class ContractBrookerState extends BaseTradePerson implements
IContractBroker, IUpdateableState {
    @Getter
	private String name;
	/*
	 * TODO use brooker names
	 */
	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

	/**
	 * Generate a name of the broker.
	 */
	@Override
	public void update() {
		name = firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName();
	}

}
