package ch.sahits.game.openpatrician.model.people.impl;



import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * Implementation of a courier. Every city can have a courier and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class CourierState extends BasePatrolState implements ICourier, IUpdatableCityRelatedState {
	@Autowired
	private Random rnd;
	@Autowired
	private CityUtilities cityUtils;
    @Getter
    @Setter
	private int premium;
	/*
	 * Use custom names
	 */
	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");


	@Override
	public void update(ICity startCity) {
		setName(firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName());
		setPremium(rnd.nextInt(2000)+4300);
		int nbDestinations = rnd.nextInt(3)+3;
		destinations = new ICity[nbDestinations];
		updateDestinations(startCity, nbDestinations);
	}


	private void updateDestinations(ICity startCity, int nbDestinations) {
		List<ICity> visited = new ArrayList<ICity>();
		visited.add(startCity);
		ICity curCity = startCity;
		for (int i=0; i<nbDestinations; i++) {
			ICity next = cityUtils.findNearbyCityRepeated(curCity, .2, 1024, visited);
			destinations[i] = next;
			visited.add(next);
			curCity = next;
		}
		currentDestIndex = 0;
	}

}
