package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.people.IThieve;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Random;

/**
 * Implementation of a thieve. Every city can have a thieve and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class ThieveState extends BaseTavernPerson implements IThieve, IUpdateableState {
	@Autowired
	private Random rnd;
    @Getter
    @Setter(AccessLevel.PRIVATE)
	private int price;

	@Override
	public void update() {
		setPrice(rnd.nextInt(400)+100);
	}
}
