package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * Implementation of a transport trader. Every city can have a transport trader and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
public class TransportTraderState extends BaseTavernPerson implements
ITransportTrader, IUpdatableCityRelatedState {
	@Autowired
	private Random rnd;
	@Autowired
	private CityUtilities cityUtils;
    @Getter
    @Setter(AccessLevel.PRIVATE)
    private String name;
    @Getter
    @Setter(AccessLevel.PRIVATE)
    private ICity destination;
    @Getter
    @Setter(AccessLevel.PRIVATE)
	private int premium;
    @Getter
    @Setter(AccessLevel.PRIVATE)
    private int neededCapacity;

	private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
	private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");


	@Override
	public void update(ICity currentCity) {
		setName(firstNameLoader.getRandomName()+" "+lastNameLoader.getRandomName());
		setPremium(rnd.nextInt(700)+300);
		setNeededCapacity(rnd.nextInt(40)+4);
		List<ICity> visited = new ArrayList<ICity>();
		visited.add(currentCity);
		ICity next = cityUtils.findNearbyCityRepeated(currentCity, 1, 1024, visited);
		setDestination(next);
	}
}
