package ch.sahits.game.openpatrician.model.personal;


/**
 * Indicating the reputation of a player in a city. This is updated on a weekly basis
 * The reputation is periodically updated.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
public interface IReputation {
	/**
	 * Retrieve the change in reputation within the last week.
	 * Single digit values indicate a small change, values larger than
	 * 25 indicate a very large change. 
	 * @return
	 */
	public int getReputationDifference();
	/**
	 * Retrieve the popularity of the player in the city
	 * @return
	 */
	public int getPopularity();
}
