package ch.sahits.game.openpatrician.util;

import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import javafx.beans.property.ObjectProperty;
import org.springframework.stereotype.Component;

/**
 * This class provides some utility functions that are required by different UIs.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 22, 2013
 */
@Component
public class TransferUtil {
    /**
     * Calculate the available amount to be transfered.
     * @param maxAmount maximal amount that is stored. This is the amount that is the upper bound,
     *                  which can be transferred.
     * @param movableAmount size type indicating how much should be moved.
     * @return amount that can be transferred
     */
    public int calculateAvailableAmount(ObjectProperty<ETransferAmount> movableAmount, int maxAmount) {
        return calculateAvailableAmount(movableAmount.get(), maxAmount);
    }
    /**
     * Calculate the available amount to be transfered.
     * @param maxAmount maximal amount that is stored. This is the amount that is the upper bound,
     *                  which can be transferred.
     * @param movableAmount size type indicating how much should be moved.
     * @return amount that can be transferred
     */
    public int calculateAvailableAmount(ETransferAmount movableAmount, int maxAmount) {
        switch (movableAmount){
            case ONE:
                return Math.min(maxAmount,1);
            case FIVE:
                if (maxAmount<5) {
                    return maxAmount;
                }
                return 5;
            case MAX:
                return maxAmount;
        }
        throw new RuntimeException("Not reachable statement");
    }
}
