/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class Date {
    private int tickUpdate;
    private ObjectProperty<DateTime> cal = new SimpleObjectProperty((Object)this, "cal", null);
    private DateTime startDate;
    private Integer startYear = null;
    private static Object lock = new Object();
    private StringBinding dayDateBinding = null;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public Date(int year) {
        this();
        this.setStartYear(year);
    }

    public Date() {
        this.tickUpdate = 5;
    }

    public void setStartYear(int startYear) {
        Preconditions.checkState((this.startYear == null ? 1 : 0) != 0, (Object)"Date may only be initialized once");
        System.out.println("+++++++++++++++++++ set start year: " + startYear);
        this.startYear = startYear;
        this.updateTime(new DateTime(startYear, 7, 13, 0, 0));
        this.startDate = this.getCurrentDate();
    }

    Date(DateTime cal) {
        this.updateTime(cal);
        this.startYear = cal.getYear();
        this.tickUpdate = 5;
    }

    public void updateTime(DateTime newTime) {
        Preconditions.checkNotNull((Object)newTime);
        this.cal.set((Object)newTime);
    }

    public void setTickUpdate(int minutes) {
        this.tickUpdate = minutes;
        ClockTickIntervalChange event = new ClockTickIntervalChange();
        event.setInterval(this.tickUpdate);
        this.clientServerEventBus.post((Object)event);
    }

    public String getStartOfWeek() {
        DateTime lastMon = this.getStartOfWeekInternal();
        return this.toShortDate(lastMon);
    }

    DateTime getStartOfWeekInternal() {
        DateTime lastMonday = ((DateTime)this.cal.get()).minusWeeks(1);
        lastMonday = lastMonday.minusDays(lastMonday.getDayOfWeek() - 1);
        return lastMonday;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toShortDate(DateTime c) {
        int month;
        int day;
        Object object = lock;
        synchronized (object) {
            day = c.getDayOfMonth();
            month = c.getMonthOfYear();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(day).append(". ");
        sb.append(this.messageSource.getMessage("month_short_" + month, new Object[0], this.locale.getCurrentLocal()));
        return sb.toString();
    }

    public String getEndOfWeek() {
        DateTime lastSun = this.getEndOfWeekInternal();
        return this.toShortDate(lastSun);
    }

    DateTime getEndOfWeekInternal() {
        int cdow = ((DateTime)this.cal.get()).getDayOfWeek();
        DateTime lastDayOfWeek = ((DateTime)this.cal.get()).plusDays(7 - cdow);
        return lastDayOfWeek;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDisplayString() {
        int year;
        int month;
        int day;
        Object object = lock;
        synchronized (object) {
            day = ((DateTime)this.cal.get()).getDayOfMonth();
            month = ((DateTime)this.cal.get()).getMonthOfYear();
            year = ((DateTime)this.cal.get()).getYear();
        }
        return this.todisplayString(day, month, year);
    }

    public StringBinding dayDateBinding() {
        if (this.dayDateBinding == null) {
            this.dayDateBinding = new StringBinding(){

                protected String computeValue() {
                    return Date.this.toDisplayString();
                }
            };
        }
        return this.dayDateBinding;
    }

    public String todisplayString(int day, int month, int year) {
        StringBuilder sb = new StringBuilder();
        sb.append(day).append(". ");
        sb.append(this.messageSource.getMessage("month_short_" + month, new Object[0], this.locale.getCurrentLocal())).append(" ");
        sb.append(year);
        return sb.toString();
    }

    public DateTime getCurrentDate() {
        return (DateTime)this.cal.get();
    }

    public ObjectProperty<DateTime> getCurrentDateProperty() {
        return this.cal;
    }

    public final int getWeekdayIndex() {
        int dayOfWeek = ((DateTime)this.cal.get()).getDayOfWeek() + 1;
        return (dayOfWeek - 2) % 7;
    }

    public int getTickUpdate() {
        return this.tickUpdate;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public Integer getStartYear() {
        return this.startYear;
    }
}

