/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.EDifficultyLevel;

public final class Difficulty {
    public static final Difficulty CHANDLER = new Difficulty(EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, 30000, 2);
    public static final Difficulty MERCHANT = new Difficulty(EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.EASY, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, 10000, 2);
    public static final Difficulty TRADESMAN = new Difficulty(EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, 10000, 1);
    public static final Difficulty COUNSILMAN = new Difficulty(EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.NORMAL, EDifficultyLevel.HARD, EDifficultyLevel.HARD, 1000, 1);
    public static final Difficulty PATRICIAN = new Difficulty(EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, EDifficultyLevel.HARD, 1000, 1);
    private final EDifficultyLevel trade;
    private final EDifficultyLevel approval;
    private final EDifficultyLevel need;
    private final EDifficultyLevel navalBattle;
    private final EDifficultyLevel pirateActivity;
    private final EDifficultyLevel sovereignActivity;
    private final int startingCapital;
    private final int numberOfShips;

    public static Difficulty fromIndex(int selectedIndex) {
        switch (selectedIndex) {
            case 0: {
                return CHANDLER;
            }
            case 1: {
                return MERCHANT;
            }
            case 2: {
                return TRADESMAN;
            }
            case 3: {
                return COUNSILMAN;
            }
            case 4: {
                return PATRICIAN;
            }
        }
        throw new IndexOutOfBoundsException("No matching difficulty for index " + selectedIndex);
    }

    public Difficulty(EDifficultyLevel trade, EDifficultyLevel approval, EDifficultyLevel need, EDifficultyLevel navalBattle, EDifficultyLevel pirateActivity, EDifficultyLevel sovereignActivity, int startingCapital, int numberOfShips) {
        this.trade = trade;
        this.approval = approval;
        this.need = need;
        this.navalBattle = navalBattle;
        this.pirateActivity = pirateActivity;
        this.sovereignActivity = sovereignActivity;
        this.startingCapital = startingCapital;
        this.numberOfShips = numberOfShips;
    }

    public EDifficultyLevel getTrade() {
        return this.trade;
    }

    public EDifficultyLevel getApproval() {
        return this.approval;
    }

    public EDifficultyLevel getNeed() {
        return this.need;
    }

    public EDifficultyLevel getNavalBattle() {
        return this.navalBattle;
    }

    public EDifficultyLevel getPirateActivity() {
        return this.pirateActivity;
    }

    public EDifficultyLevel getSovereignActivity() {
        return this.sovereignActivity;
    }

    public int getStartingCapital() {
        return this.startingCapital;
    }

    public int getNumberOfShips() {
        return this.numberOfShips;
    }
}

