/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.event.data.PeriodicalTimeDayUpdate;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ELevel;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWarehouse;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.factory.PeriodicalTimeUpdateFactory;
import ch.sahits.game.openpatrician.model.time.EUpdateIntervalRegistration;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
public class Storage
implements IStorage {
    @Autowired
    private PeriodicalTimeUpdateFactory updateFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    public static final int GUARD_COST_PER_DAY = 10;
    public static final int RENT_COST_PER_DAY_AND_BALE = 20;
    private final IPlayer owner;
    private final ICity city;
    private IntegerProperty rentOutStorage;
    private IntegerProperty nbGuards;

    public Storage(IPlayer owner, ICity city) {
        this.owner = owner;
        this.city = city;
        this.rentOutStorage = new SimpleIntegerProperty((Object)this, "rentOutStorage", 0);
        this.nbGuards = new SimpleIntegerProperty((Object)this, "nbGuards", 0);
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
        this.updateFactory.createPeriodicalUpdater(EUpdateIntervalRegistration.END_OF_DAY);
    }

    private int getNbWareHouses() {
        return this.owner.findBuildings(this.city, IWarehouse.class).size();
    }

    @Override
    public IntegerProperty rentOutStorageProperty() {
        return this.rentOutStorage;
    }

    @Override
    public void updateRendedSpace(int nbBarrels) {
        if (-nbBarrels > this.rentOutStorage.get()) {
            this.rentOutStorage.set(0);
        } else {
            int newValue = this.rentOutStorage.get() + nbBarrels;
            this.rentOutStorage.set(newValue);
        }
    }

    @Override
    public IntegerBinding costsPerDayBinding() {
        final ITradingOffice office = this.owner.findTradingOffice(this.city);
        IntegerBinding additionalCosts = new IntegerBinding(){
            {
                super.bind(new Observable[]{office.capacityProperty(), office.storedAmountBinding()});
            }

            protected int computeValue() {
                int additional = office.capacityProperty().subtract((ObservableNumberValue)office.storedAmountBinding()).intValue();
                if (additional >= 0) {
                    return 0;
                }
                return (-additional / 10 + 1) * 20;
            }
        };
        return additionalCosts;
    }

    @Override
    public IntegerProperty numberGuardsProperty() {
        return this.nbGuards;
    }

    @Override
    public IntegerBinding guardCostsPerDayBinding() {
        return this.nbGuards.multiply(10);
    }

    @Override
    public ObjectBinding<ELevel> securityLevelBinding() {
        return new ObjectBinding<ELevel>(){

            protected ELevel computeValue() {
                return Storage.this.internalSecurityLevelCalculation();
            }
        };
    }

    private ELevel internalSecurityLevelCalculation() {
        double nb = this.getNbWareHouses();
        double factor = (double)this.nbGuards.get() / (nb + 1.0);
        if (factor >= 1.0) {
            return ELevel.MAXIMUM;
        }
        if (factor >= 0.66) {
            return ELevel.HIGH;
        }
        if (factor <= 0.33) {
            return ELevel.LOW;
        }
        return ELevel.MEDIUM;
    }

    @Override
    public void updateGuardsNumber(int update) {
        if (-update > this.nbGuards.get()) {
            this.nbGuards.set(0);
        } else {
            int newValue = this.nbGuards.get() + update;
            this.nbGuards.set(newValue);
        }
    }

    @Subscribe
    public void handleDailyUpdate(PeriodicalTimeDayUpdate event) {
        int costs = this.costsPerDayBinding().add((ObservableNumberValue)this.guardCostsPerDayBinding()).intValue();
        this.owner.updateCash(-costs);
    }

    static /* synthetic */ IntegerProperty access$000(Storage x0) {
        return x0.nbGuards;
    }
}

