/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.PropertyLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.stereotype.Service;

@Service
public class CityProduction {
    private Map<IWare, Integer> productionRates = new HashMap<IWare, Integer>();

    public CityProduction() {
        EWare[] wares;
        Properties props = PropertyLoader.loadProperties((String)"productionrates.properties");
        for (EWare ware : wares = EWare.values()) {
            this.productionRates.put(ware, Integer.parseInt(props.getProperty(ware.name())));
        }
    }

    public int getEfficientProduction(IWare ware) {
        return this.productionRates.get(ware);
    }

    public int getInefficientProduction(IWare ware) {
        return this.productionRates.get(ware) / 2;
    }
}

